<?php
// ---------------- CONFIG ----------------
define('BOT_TOKEN', '8404862522:AAG2jq-kBH8mzNlLVNE_tYavuouI97jPafg');
define('SMM_API_URL', 'https://mysmmprovider.com/api/v2');
define('SMM_API_KEY', '1422e7e080dfeba0d687c787b93a8b23');
define('NOTIFY_CHANNEL', '@dllsmmbotorders');
define('LOG_FILE', __DIR__ . '/auto_order_log.txt');
define('LAST_FILE', __DIR__ . '/last_processed.json');
define('QTY_FILE', __DIR__ . '/channel_qty.php');
define('SERVICES_FILE', __DIR__ . '/services.php');
// -----------------------------------------

function logit($m) {
    file_put_contents(LOG_FILE, date("Y-m-d H:i:s") . " - " . $m . PHP_EOL, FILE_APPEND);
}

// load configs
$channelQty = file_exists(QTY_FILE) ? include(QTY_FILE) : [];
$services = file_exists(SERVICES_FILE) ? include(SERVICES_FILE) : [];

// ✅ Normalize all keys in channelQty to lowercase for case-insensitive match
$normalizedQty = [];
foreach ($channelQty as $key => $val) {
    $normalizedQty[strtolower($key)] = $val;
}
$channelQty = $normalizedQty;

$body = file_get_contents('php://input');
if (!$body) exit;
$update = json_decode($body, true);
logit("Update: " . substr($body, 0, 500));

$last = file_exists(LAST_FILE) ? (json_decode(file_get_contents(LAST_FILE), true) ?: []) : [];

// ---------------- HANDLE CHANNEL POST ----------------
if (isset($update['channel_post'])) {
    $post = $update['channel_post'];
    $chat_id = $post['chat']['id'];
    $username = isset($post['chat']['username']) ? strtolower($post['chat']['username']) : null;
    $msg_id = $post['message_id'];

    // ✅ Lowercase key for matching
    $chanKey = $username ?: $chat_id;
    $chanKey = strtolower($chanKey);

    // ✅ Only allow processing if channel is in channel_qty.php
    if (!isset($channelQty[$chanKey])) {
        logit("❌ Ignored message from unauthorized channel: {$chanKey}");
        unauthorized_reply($chat_id, $msg_id);
        exit("unauthorized");
    }

    // Prevent duplicate processing
    $key = (string)$chat_id;
    if (isset($last[$key]) && $last[$key] >= $msg_id) {
        logit("Duplicate skipped $chat_id / $msg_id");
        exit;
    }
    $last[$key] = $msg_id;
    file_put_contents(LAST_FILE, json_encode($last));

    // Build message link
    if ($username) {
        $link = "https://t.me/{$username}/{$msg_id}";
    } else {
        $cid = preg_replace('/^-100/', '', (string)$chat_id);
        $link = "https://t.me/c/{$cid}/{$msg_id}";
    }

    // Process services
    foreach ($services as $srv) {
        $srvId = intval($srv['id']);
        $defaultQty = isset($srv['qty']) ? intval($srv['qty']) : 0;
        $qty = $defaultQty;

        // Override qty if defined for this channel
        if (isset($channelQty[$chanKey][$srvId]) && intval($channelQty[$chanKey][$srvId]) > 0) {
            $qty = intval($channelQty[$chanKey][$srvId]);
        }

        if ($qty <= 0) {
            logit("Skipped service {$srvId} for channel {$chanKey} because qty<=0 (default {$defaultQty})");
            continue;
        }

        // Place order
        $res = place_order($link, $qty, $srvId);

        // Notify on Telegram
        $txt = "📄 *Auto Order Submitted*\n\n"
             . "✅ Service ID = {$srvId}\n"
             . "👁 Qty = {$qty}\n"
             . "🔗 Link = {$link}";
        notify(NOTIFY_CHANNEL, $txt);

        logit("Order placed: Service {$srvId} | Channel {$chanKey} | Link {$link} => " . json_encode($res));
    }

    echo "OK";
    exit;
}

echo "noop";
exit;

// ---------------- HELPER FUNCTIONS ----------------
function place_order($link, $qty, $serviceId) {
    $payload = [
        'key' => SMM_API_KEY,
        'action' => 'add',
        'service' => $serviceId,
        'link' => $link,
        'quantity' => $qty
    ];
    $ch = curl_init(SMM_API_URL);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    $res = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    if ($err) return ['error' => $err];
    return json_decode($res, true) ?: ['raw' => $res];
}

function notify($chat_id, $text) {
    if (!$chat_id) return;
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/sendMessage";
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'Markdown',
        'disable_web_page_preview' => true
    ];
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_exec($ch);
    curl_close($ch);
}

// ---------------- UNAUTHORIZED REPLY FUNCTION ----------------
function unauthorized_reply($chat_id, $reply_to_msg_id) {
    $text = "⚠️ *TOP MSP bot is not authorized for this channel.*\n\n"
          . "To start your views + reaction subscription contact 👇🏻 ";

    // Inline button for Contact Now
    $keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '📞 Contact Now', 'url' => 'https://t.me/Mysmmprovider']]
        ]
    ]);

    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/sendMessage";
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'Markdown',
        'disable_web_page_preview' => true,
        'reply_to_message_id' => $reply_to_msg_id,
        'reply_markup' => $keyboard
    ];
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_exec($ch);
    curl_close($ch);
}